/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBWidgetCarousel = Object.create(STBModule.prototype);

STBWidgetCarousel.name = "WidgetCarousel";
STBWidgetCarousel.initPlugin = function() {

    try {
        var carouselDir = false,
            owlCarouselWg = jQuery('.owl-carousel.owl-carousel-widget:not(.___done_carousel)'),
			bigMargin = 30,
			smallMargin = 8;

        if (jQuery("html").attr("dir") == "rtl") {
            carouselDir = true;
        }

        if (owlCarouselWg.length > 0) {

            owlCarouselWg.each(function () {


                var obj = jQuery(this),
                    $time		= STBUtils.attrDefaultValue(obj.attr("data-speed"), 0),
                    $dots		= STBUtils.attrDefaultValue(obj.attr("data-dots"), "1") == "1",
                    $nav		= STBUtils.attrDefaultValue(obj.attr("data-nav"), "1") == "1",
                    $items		= STBUtils.attrDefaultValue(obj.attr("data-items"), 1),
                    $items_lg	= STBUtils.attrDefaultValue(obj.attr("data-items-lg"), $items),
                    $items_md	= STBUtils.attrDefaultValue(obj.attr("data-items-md"), $items_lg),
                    $items_sm	= STBUtils.attrDefaultValue(obj.attr("data-items-sm"), $items_md),
                    $items_xs	= STBUtils.attrDefaultValue(obj.attr("data-items-xs"), $items_sm),
					$margin		= STBUtils.attrDefaultValue(obj.attr("data-margin"), -1),
                    $animateOut = STBUtils.attrDefaultValue(obj.attr("data-anim-out"), false),
                    $animateIn	= STBUtils.attrDefaultValue(obj.attr("data-anim-in"), false),
                    $thumbs		= STBUtils.attrDefaultValue(obj.attr("data-thumbs"), false);
//                    $thumbsPre	= STBUtils.attrDefaultValue(obj.attr("data-thumbs-prerender"), $thumbs ? false);

					if ($animateOut == "{SET_CAROUSEL_OUT}") {
						$animateOut = false;
					}

					if ($animateIn == "{SET_CAROUSEL_IN}") {
						$animateIn = false;
					}


				if ($margin == -1) {
					var container = obj.closest("section").find(".container-data");
					var widget = obj.closest(".widget");

					if (container.hasClass("container-fluid")) {
						if (widget.hasClass("widget-carousel-margin-small")) {
							$margin = 0;
						} else {
							$margin = bigMargin;
						}
					} else {

						if (widget.hasClass("widget-carousel-margin-small")) {
							$margin = smallMargin;
						} else {
							$margin = bigMargin;
						}	
					}
				} 

                $items = STBUtils.bootstrapCols($items);
                $items_xs = STBUtils.bootstrapCols($items_xs);
                $items_sm = STBUtils.bootstrapCols($items_sm);
                $items_md = STBUtils.bootstrapCols($items_md);
                $items_lg = STBUtils.bootstrapCols($items_lg);

				obj.on('initialized.owl.carousel resized.owl.carousel', function() {
					site.runOnContentUpdate();

					if (obj.hasClass("same-height")){
						obj.find(".owl-item > .isotope-element > *").matchHeight({ byRow : true}); 
					}

					obj.find(".owl-item").each(function() {
						jQuery(this).height(Math.floor(jQuery(this).height()));
					});
				}).on("resize.owl.carousel" , function() {

					if (obj.hasClass("same-height")){
						obj.find(".owl-item > .isotope-element > *").matchHeight({ byRow : true}); 
					}

					site.runOnContentUpdate();
					obj.find(".owl-item").each(function() {
						jQuery(this).css("height" , "auto");
					});
				});

				var $margin_xs = parseInt($margin),
					$margin_sm = parseInt($margin),
					$margin_md = parseInt($margin),
					$margin_lg = parseInt($margin);
		
				if ($items_xs == 1) $margin_xs = 0;
				if ($items_md == 1) $margin_md = 0;
				if ($items_sm == 1) $margin_sm = 0;
				if ($items_lg == 1) $margin_lg = 0;

/*
				if ($thumbs) {
					$slides = obj.find(" > .isotope-element"),
					$thumbsCarousel = $("<div />");
					$thumbsCarousel.addClass("owl-thumbs");

					$slides.each(function() {
						$(this).clone().appendTo($thumbsCarousel);
					});

					$thumbsCarousel.appendTo(obj.parent());

					console.log($thumbsCarousel);
				}
*/


				obj.imagesLoaded(function() {
					obj.owlCarousel({

						rtl					: carouselDir,
						//disable loop if has thumbs enabled
						loop				: $thumbs ? false : true,
						dots				: $dots,
						nav					: $nav,
						navText				: false,
						video				: true,
						margin				: parseInt($margin),
						autoplay			: $time > 0 ? true : false,
						autoplayTimeout		: $time,
						autoplayHoverPause	: true,
						autoHeight			: false,
						mouseDrag			: false,
						items				: $items,
						responsiveClass		: true,
						animateOut			: $animateOut,
						animateIn			: $animateIn,

						responsive: {
							0: {
								items	: $items_xs
							},

							576: {
								items	: $items_sm
							},

							768: {
								items	: $items_md
							},

							992: {
								items	: $items_lg
							},
							1200: {
								items	: $items
							}
						}
					});

					if ($thumbs) {

						var thumbsSlider = obj.siblings(".owl-thumbs"),
							duration = 250;

//						console.log(thumbsSlider);

						thumbsSlider.owlCarousel({
							loop:false,
							center:true,
							nav:false,
							margin: 10,
							responsive:{
								0:{
									items:3
								},
								600:{
									items:4
								},
								1000:{
									items:4
								}
							}
						}).on('click', '.owl-item', function () {
							// On click of thumbnail items to trigger same main item
							obj.trigger('to.owl.carousel', [jQuery(this).index(), duration, true]);
							//console.log(obj);

						}).on('changed.owl.carousel', function (e) {
							// On change of thumbnail item to trigger main item
							obj.trigger('to.owl.carousel', [e.item.index, duration, true]);
						});

						obj.on('changed.owl.carousel', function (e) {
							//On change of main item to trigger thumbnail item
							thumbsSlider.trigger('to.owl.carousel', [e.item.index, duration, true]);
							
						});
					}

				});



				jQuery(this).addClass("___done_carousel");
            });

        }

    } catch (e) {
        getStack(0, e);
    }
}

STBWidgetCarousel.runOnReady = function() {
	STBWidgetCarousel.initPlugin();
}

STBWidgetCarousel.runOnContentUpdate = function() {
	STBWidgetCarousel.initPlugin();
}


site.registerModule(STBWidgetCarousel);